/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.kintai.dao.CmRotationDao;
import jp.mosp.kintai.dto.CmRotationDto;
import jp.mosp.kintai.vo.ScheduleRotationCardVo;

public class ScheduleRotationCardAction extends MosPAction{

	// R}h
	private static final String CMD_ROTATION_CARD_SHOW   = "K1215";	// \(ǉ)
	private static final String CMD_ROTATION_CARD_SELECT = "K1216";	// \(I)
	private static final String CMD_ROTATION_CARD_INSERT = "K1217";	// o^
	private static final String CMD_ROTATION_CARD_UPDATE = "K1218";	// XV

	/**
	 * RXgN^
	 */
	public ScheduleRotationCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// VO̎擾yѐݒ
		ScheduleRotationCardVo vo = new ScheduleRotationCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾
		getConnection();
		// DAȌ
		CmRotationDao dao = new CmRotationDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// R[h敪v_EXg쐬
		vo.aryPltWorkType = getWorkTypeArrayWithWeekHoliday();
		vo.aryPltHoliday  = getApplicableFlagArray();
		// DTO̎擾
		CmRotationDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof CmRotationDto ? (CmRotationDto)obj : null;
		// [U[擾
		getInfo(user.getUserId());
		// R}h̏
		if (cmd.equals(CMD_ROTATION_CARD_SHOW)) {
			// \(VK)
			vo.setDefaultValues();			
			vo.setMode(ScheduleRotationCardVo.MODE_INSERT);		
		} else if (cmd.equals(CMD_ROTATION_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = dao.findForKey(mKihon.getKCode(), key1);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			setMode(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_ROTATION_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_ROTATION_CARD_UPDATE)) {	
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private CmRotationDto insert(ScheduleRotationCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// RlNV̎擾yDAȌ
		getConnection();
		CmRotationDao dao = new CmRotationDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(mKihon.getKCode(), vo.getTxtRTCode()), vo);
		// DTȌ
		CmRotationDto dto = new CmRotationDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setDtoFields(dto);
		dto.setKCode(mKihon.getKCode());
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(mKihon.getKCode(), dto.getRtCode());
		// R~bg
		commit();
		// [hݒ
		setMode(vo);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private CmRotationDto update(ScheduleRotationCardVo vo, CmRotationDto dto) throws Exception {
		vo.setMode(ScheduleRotationCardVo.MODE_UPDATE);
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		CmRotationDao dao = new CmRotationDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(mKihon.getKCode(), vo.getTxtRTCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		dto.setKCode(mKihon.getKCode());
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		CmRotationDto retDto = dao.findForKey(mKihon.getKCode(), dto.getRtCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode(vo);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(ScheduleRotationCardVo vo) throws Exception {
		// [hݒ
		vo.setMode(ScheduleRotationCardVo.MODE_UPDATE);
	}

}
